package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur;

import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByDay;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByHour;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByMinute;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByMonth;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByMonthDay;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartBySecond;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartBySetPos;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByWeekNo;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartByYearDay;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartCount;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartFreq;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartInterval;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartUntil;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartWkSt;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type.IcsRecurRulePartXExclude;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObjects;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfProperties;
import ru.yandex.misc.reflection.ClassX;


/**
 * @author Stepan Koltsov
 * @see VcfProperties
 */
public class IcsRecurRuleParts extends IvObjects<IcsRecurRulePart, IcsRecurRulePartMeta> {

    public static final IcsRecurRuleParts P = new IcsRecurRuleParts();

    @SuppressWarnings("unchecked")
    @Override
    protected Class<IcsRecurRulePart>[] getTypes() {
        return new Class[] {
            IcsRecurRulePartByDay.class,
            IcsRecurRulePartByHour.class,
            IcsRecurRulePartByMinute.class,
            IcsRecurRulePartByMonth.class,
            IcsRecurRulePartByMonthDay.class,
            IcsRecurRulePartBySecond.class,
            IcsRecurRulePartBySetPos.class,
            IcsRecurRulePartByWeekNo.class,
            IcsRecurRulePartByYearDay.class,
            IcsRecurRulePartCount.class,
            IcsRecurRulePartFreq.class,
            IcsRecurRulePartInterval.class,
            IcsRecurRulePartUntil.class,
            IcsRecurRulePartWkSt.class,
            IcsRecurRulePartXExclude.class,
        };
    }

    @Override
    public IcsRecurRulePartMeta meta(ClassX<IcsRecurRulePart> type) {
        return new IcsRecurRulePartMeta(type);
    }

    public IcsRecurRulePart newPart(String name, String value) {
        return byName.getOrThrow(name, "part not found by name, ", name).newPart(value);
    }
} //~
