package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur;

import org.joda.time.Instant;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Either;

/**
 * @author Daniel Brylev <dbrylev@yandex-team.ru>
 */
public class IcsRecurUntil {

    private final Either<Instant, LocalDate> until;

    private IcsRecurUntil(Either<Instant, LocalDate> until) {
        this.until = until;
    }

    public static IcsRecurUntil dateTime(Instant instant) {
        return new IcsRecurUntil(Either.<Instant, LocalDate>left(instant));
    }

    public static IcsRecurUntil date(LocalDate date) {
        return new IcsRecurUntil(Either.<Instant, LocalDate>right(date));
    }

    public boolean isDate() {
        return until.isRight();
    }

    public LocalDate getDate() {
        return until.getRight();
    }

    public boolean isDateTime() {
        return until.isLeft();
    }

    public Instant getDateTime() {
        return until.getLeft();
    }
}
