package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurRulePartByDay extends IcsRecurRulePart {

    public static final String BYDAY = "BYDAY";

    private final ListF<WeekDay> days;

    public IcsRecurRulePartByDay(String value) {
        this(Cf.x(new WeekDayList(value)));
    }

    public IcsRecurRulePartByDay(ListF<WeekDay> days) {
        super(BYDAY, days.mkString(","));
        Validate.notEmpty(days);
        this.days = days;
    }

    public ListF<WeekDay> getDays() {
        return days;
    }

    public static Function<IcsRecurRulePartByDay, ListF<WeekDay>> getDaysF() {
        return new Function<IcsRecurRulePartByDay, ListF<WeekDay>>() {
            public ListF<WeekDay> apply(IcsRecurRulePartByDay pbd) {
                return pbd.getDays();
            }
        };
    }
} //~
