package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;
import ru.yandex.misc.lang.Validate;

/**
 * @author Daniel Brylev <dbrylev@yandex-team.ru>
 */
public abstract class IcsRecurRulePartByNumberList extends IcsRecurRulePart {

    private final ListF<Integer> numbers;

    IcsRecurRulePartByNumberList(String name, String value, int minvalue, int maxvalue, boolean allowNegative) {
        this(name, Cf.x(value.split(",")).map(Cf.Integer.parseDecimalF()), minvalue, maxvalue, allowNegative);
        Validate.notEmpty(value);
    }

    IcsRecurRulePartByNumberList(String name, ListF<Integer> numbers, int minvalue, int maxvalue, boolean allowNegative) {
        super(name, numbers.mkString(","));
        Validate.notEmpty(numbers);
        if (!allowNegative) Validate.forAll(numbers, Cf.Integer.geF(0));
        Validate.forAll(numbers.map(absF()), Cf.Integer.geF(minvalue).andF(Cf.Integer.leF(maxvalue)));
        this.numbers = numbers;
    }

    private static Function<Integer, Integer> absF() {
        return new Function<Integer, Integer>() {
            public Integer apply(Integer integer) {
                return Math.abs(integer);
            }
        };
    }

    public ListF<Integer> getNumbers() {
        return numbers;
    }

    public static Function<IcsRecurRulePartByNumberList, ListF<Integer>> getNumbersF() {
        return new Function<IcsRecurRulePartByNumberList, ListF<Integer>>() {
            public ListF<Integer> apply(IcsRecurRulePartByNumberList l) {
                return l.getNumbers();
            }
        };
    }

}
