package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurRulePartCount extends IcsRecurRulePart {

    public static final String COUNT = "COUNT";

    private final int count;

    public IcsRecurRulePartCount(String value) {
        this(Integer.parseInt(value));
    }

    public IcsRecurRulePartCount(int count) {
        super(COUNT, String.valueOf(count));
        Validate.isTrue(count > 0, "Count must be positive number");
        this.count = count;
    }

    public int getCount() {
        return count;
    }

    public static Function<IcsRecurRulePartCount, Integer> getCountF() {
        return new Function<IcsRecurRulePartCount, Integer>() {
            public Integer apply(IcsRecurRulePartCount pc) {
                return pc.getCount();
            }
        };
    }
} //~
