package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurRulePartInterval extends IcsRecurRulePart {

    public static final String INTERVAL = "INTERVAL";

    private final int interval;

    public IcsRecurRulePartInterval(String value) {
        this(Integer.parseInt(value));
    }

    public IcsRecurRulePartInterval(int interval) {
        super(INTERVAL, String.valueOf(interval));
        Validate.isTrue(interval > 0, "Interval must be positive number");
        this.interval = interval;
    }

    public int getInterval() {
        return interval;
    }

    public static Function<IcsRecurRulePartInterval, Integer> getIntervalF() {
        return new Function<IcsRecurRulePartInterval, Integer>() {
            public Integer apply(IcsRecurRulePartInterval p) {
                return p.getInterval();
            }
        };
    }
} //~
