package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.dateTime.IcsDateTimeFormats;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurUntil;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurRulePartUntil extends IcsRecurRulePart {

    public static final String UNTIL = "UNTIL";

    private final IcsRecurUntil until;

    public IcsRecurRulePartUntil(String value) {
        super(UNTIL, value);
        if (value.length() == 8) {
            until = IcsRecurUntil.date(IcsDateTimeFormats.parseDate(value));
        } else {
            until = IcsRecurUntil.dateTime(IcsDateTimeFormats.parseDateTime(value));
        }
    }

    public IcsRecurRulePartUntil(IcsRecurUntil until) {
        super(UNTIL, until.isDate() ?
                IcsDateTimeFormats.formatDate(until.getDate()) :
                IcsDateTimeFormats.formatDateTime(until.getDateTime()));
        this.until = until;
    }

    public IcsRecurUntil getUntil() {
        return until;
    }

    public static Function<IcsRecurRulePartUntil, IcsRecurUntil> getUntilF() {
        return new Function<IcsRecurRulePartUntil, IcsRecurUntil>() {
            public IcsRecurUntil apply(IcsRecurRulePartUntil pu) {
                return pu.getUntil();
            }
        };
    }
} //~
