package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import net.fortuna.ical4j.model.WeekDay;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;

/**
 * @author Stepan Koltsov
 */
public class IcsRecurRulePartWkSt extends IcsRecurRulePart {

    public static final String WKST = "WKST";

    private final WeekDay day;

    public IcsRecurRulePartWkSt(String value) {
        this(new WeekDay(value));
    }

    public IcsRecurRulePartWkSt(WeekDay day) {
        super(WKST, day.toString());
        this.day = day;
    }

    public WeekDay getDay() {
        return day;
    }

    public static Function<IcsRecurRulePartWkSt, WeekDay> getDayF() {
        return new Function<IcsRecurRulePartWkSt, WeekDay>() {
            public WeekDay apply(IcsRecurRulePartWkSt pws) {
                return pws.getDay();
            }
        };
    }
} //~
