package ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.type;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePart;

/**
 * @author dbrylev
 */
public class IcsRecurRulePartXExclude extends IcsRecurRulePart {
    public static final String NAME = "X-EXCLUDE";

    private final ListF<Instant> excludes;

    public IcsRecurRulePartXExclude(String value) {
        super(NAME, value);
        this.excludes = Cf.x(getValue().split(",")).map(s -> DateTime.parse(s).toInstant());
    }

    public IcsRecurRulePartXExclude(ListF<Instant> excludes) {
        super(NAME, excludes.map(Instant::toString).mkString(","));
        this.excludes = excludes;
    }

    public ListF<Instant> getExcludes() {
        return excludes;
    }
}
