package ru.yandex.calendar.logic.ics.iv5j.support;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Stepan Koltsov
 */
public abstract class IvObject extends DefaultObject {

    protected final String name;

    public IvObject(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public static Function<IvObject, String> nameF() {
        return new Function<IvObject, String>() {
            public String apply(IvObject o) {
                return o.name;
            }
        };
    }

    public static Function1B<IvObject> nameIsF(String name) {
        return nameF().andThenEquals(name);
    }



} //~
