package ru.yandex.calendar.logic.ics.iv5j.support;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public abstract class IvObjectMeta {

    private final String name;

    public IvObjectMeta(ClassX<?> type) {
        this.name = (String) type.getStaticFieldsOfType(String.class).single().getStatic();
    }

    public String getName() {
        return name;
    }

    public static Function<IvObjectMeta, String> getNameF() {
        return new Function<IvObjectMeta, String>() {
            public String apply(IvObjectMeta ivObjectMeta) {
                return ivObjectMeta.getName();
            }
        };
    }

} //~
