package ru.yandex.calendar.logic.ics.iv5j.support;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 */
public abstract class IvObjects<O extends IvObject, M extends IvObjectMeta> {

    protected abstract Class<O>[] getTypes();

    // XXX: make protected
    public abstract M meta(ClassX<O> type);

    protected final ListF<M> properties = Cf.list(getTypes())
        .map(ClassX::wrap)
        .map(metaF());

    protected final MapF<String, M> byName = properties.toMapMappingToKey(IvObjectMeta.getNameF());

    public Function<ClassX<O>, M> metaF() {
        return new Function<ClassX<O>, M>() {
            public M apply(ClassX<O> type) {
                return meta(type);
            }
        };
    }

} //~
