package ru.yandex.calendar.logic.ics.iv5j.vcard;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfEmail;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfFn;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfProperty;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfUid;
import ru.yandex.misc.email.Email;
import ru.yandex.misc.lang.CharsetUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 * @url http://tools.ietf.org/html/rfc2426
 */
public class VcfVCard {
    private final ListF<VcfProperty> properties;

    public VcfVCard(ListF<VcfProperty> properties) {
        this.properties = properties;
    }

    public VcfVCard() {
        this(Cf.<VcfProperty>list());
    }

    public ListF<VcfProperty> getProperties() {
        return properties;
    }

    public String serialize() {
        return "BEGIN:VCARD\r\n"
            + getProperties().map(VcfProperty.serializeF()).map(s -> s + "\r\n").mkString("")
            + "END:VCARD\r\n";
    }

    public byte[] serializeToBytes() {
        return CharsetUtils.encodeUtf8ToArray(serialize());
    }

    public static VcfVCard parse(String string) {
        return VcfVCardParser.P.parse(string);
    }

    public static VcfVCard parse(byte[] bytes) {
        return VcfVCardParser.P.parse(bytes);
    }

    public VcfVCard addProperty(VcfProperty property) {
        return new VcfVCard(properties.plus1(property));
    }

    public VcfVCard addPropertyIfNotBlank(VcfProperty property) {
        return new VcfVCard(properties.plus(Option.when(StringUtils.isNotBlank(property.getValue()), property)));
    }

    public <A extends VcfProperty> ListF<A> getProperties(Class<A> type) {
        return getProperties().filterByType(type);
    }

    public <A extends VcfProperty> Option<A> getProperty(Class<A> type) {
        return getProperties(type).singleO();
    }

    public Option<String> getPropertyValue(Class<? extends VcfProperty> type) {
        return getProperty(type).map(VcfProperty.getValueF());
    }

    public <A extends VcfProperty> ListF<A> getProperties(String name) {
        return getProperties().filter(VcfProperty.nameIsF(name)).uncheckedCast();
    }

    public <A extends VcfProperty> Option<A> getProperty(String name) {
        return this.<A>getProperties(name).singleO();
    }

    public Option<String> getUid() {
        return getPropertyValue(VcfUid.class);
    }

    public Option<String> getFn() {
        return getPropertyValue(VcfFn.class);
    }

    public Option<Email> getEmail() {
        return getPropertyValue(VcfEmail.class).map(Email.consF());
    }

} //~
