package ru.yandex.calendar.logic.ics.iv5j.vcard.parameter;

import net.fortuna.ical4j.model.parameter.XParameter;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.parameter.IcsParameter;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObject;

/**
 * @author Stepan Koltsov
 * @see IcsParameter
 */
public abstract class VcfParameter extends IvObject {

    /** Escaped value */
    private final String value;

    protected VcfParameter(String name, String value) {
        super(name);
        this.value = value; // XXX: check properly escaped
    }

    public String getValue() {
        return value;
    }

    public String serialize() {
        return new XParameter(name, value).toString();
    }

    public static Function<VcfParameter, String> serializeF() {
        return new Function<VcfParameter, String>() {
            public String apply(VcfParameter p) {
                return p.serialize();
            }
        };
    }
} //~
