package ru.yandex.calendar.logic.ics.iv5j.vcard.parameter;

import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObjectMeta;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfPropertyMeta;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 * @see VcfPropertyMeta
 */
public class VcfParameterMeta extends IvObjectMeta {

    private final Function<String, ?> constructor;

    public VcfParameterMeta(ClassX<VcfParameter> type) {
        super(type);
        this.constructor = Cf2.consF(type, String.class);
    }

    @SuppressWarnings("unchecked")
    public <A extends VcfParameter> A newParameter(String value) {
        return (A) constructor.apply(value);
    }

} //~
