package ru.yandex.calendar.logic.ics.iv5j.vcard.parameter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObjects;
import ru.yandex.calendar.logic.ics.iv5j.vcard.property.VcfProperties;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 * @see VcfProperties
 */
public class VcfParameters extends IvObjects<VcfParameter, VcfParameterMeta> {

    public static final VcfParameters P = new VcfParameters();

    @SuppressWarnings("unchecked")
    @Override
    protected Class<VcfParameter>[] getTypes() {
        return new Class[] {
                VcfTypeParameter.class,
                VcfValueParameter.class,
                VcfEncodingParameter.class,
        };
    }

    @Override
    public VcfParameterMeta meta(ClassX<VcfParameter> type) {
        return new VcfParameterMeta(type);
    }

    @SuppressWarnings("unchecked")
    public <A extends VcfParameter> A newParameter(String name, String value) {
        Option<VcfParameterMeta> parameterMeta = byName.getO(name);
        if (parameterMeta.isPresent()) {
            return (A) parameterMeta.get().newParameter(value);
        } else {
            return (A) new VcfXParameter(name, value);
        }
    }

} //~
