package ru.yandex.calendar.logic.ics.iv5j.vcard.property;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfEncodingParameter;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameter;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfTypeParameter;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfValueParameter;

/**
 * @author Eugene Voytitsky
 */
public class VcfPhoto extends VcfProperty {

    public static final String PHOTO = "PHOTO";

    public VcfPhoto(String value, ListF<VcfParameter> parameters) {
        super(PHOTO, value, parameters);
    }

    // with binary data
    public VcfPhoto(String imageFormatType, char[] imageDataInBase64) {
        this(new String(imageDataInBase64),
                Cf.<VcfParameter>list(new VcfEncodingParameter("b"), new VcfTypeParameter(imageFormatType)));
    }

    // with url
    public VcfPhoto(String url) {
        this(url, Cf.<VcfParameter>list(new VcfValueParameter("uri")));
    }

}
