package ru.yandex.calendar.logic.ics.iv5j.vcard.property;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRuleParts;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObjects;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameter;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameters;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 * @see IcsRecurRuleParts
 * @see VcfParameters
 */
public class VcfProperties extends IvObjects<VcfProperty, VcfPropertyMeta> {

    public static final VcfProperties P = new VcfProperties();

    @SuppressWarnings("unchecked")
    @Override
    protected Class<VcfProperty>[] getTypes() {
        return new Class[] {
                VcfEmail.class,
                VcfFn.class,
                VcfN.class,
                VcfOrg.class,
                VcfTel.class,
                VcfUid.class,
                VcfVersion.class,
                VcfPhoto.class,
        };
    }

    @Override
    public VcfPropertyMeta meta(ClassX<VcfProperty> type) {
        return new VcfPropertyMeta(type);
    }

    @SuppressWarnings("unchecked")
    public <A extends VcfProperty> A newProperty(String name, String value, ListF<VcfParameter> parameters) {
        // XXX: support X- properties
        Option<VcfPropertyMeta> meta = byName.getO(name);
        if (meta.isPresent()) {
            return meta.get().<A>newProperty(value, parameters);
        } else {
            return (A) new VcfXProperty(name, value, parameters);
        }
    }

} //~
