package ru.yandex.calendar.logic.ics.iv5j.vcard.property;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsProperty;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObject;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameter;

/**
 * @author Stepan Koltsov
 * @see IcsProperty
 */
public abstract class VcfProperty extends IvObject {

    /** Escaped value */
    private final String value;
    private final ListF<VcfParameter> parameters;

    protected VcfProperty(String name, String value, ListF<VcfParameter> parameters) {
        super(name);
        this.value = value; // XXX: check properly escaped
        this.parameters = parameters;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    public ListF<VcfParameter> getParameters() {
        return parameters;
    }

    /** No trailing \n */
    public String serialize() {
        return name
            + getParameters().map(VcfParameter.serializeF()).map(s -> ";" + s).mkString("")
            + ":"
            + value
            ;
    }

    public static Function<VcfProperty, String> serializeF() {
        return new Function<VcfProperty, String>() {
            public String apply(VcfProperty p) {
                return p.serialize();
            }
        };
    }

    public static Function<VcfProperty, String> getValueF() {
        return new Function<VcfProperty, String>() {
            public String apply(VcfProperty vcfProperty) {
                return vcfProperty.getValue();
            }
        };
    }

} //~
