package ru.yandex.calendar.logic.ics.iv5j.vcard.property;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.ics.iv5j.ical.type.recur.IcsRecurRulePartMeta;
import ru.yandex.calendar.logic.ics.iv5j.support.IvObjectMeta;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameter;
import ru.yandex.calendar.logic.ics.iv5j.vcard.parameter.VcfParameterMeta;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author Stepan Koltsov
 * @see IcsRecurRulePartMeta
 * @see VcfParameterMeta
 */
public class VcfPropertyMeta extends IvObjectMeta {

    private final Function2<String, ListF<VcfParameter>, ?> constructor;

    public VcfPropertyMeta(ClassX<VcfProperty> type) {
        super(type);
        this.constructor = Cf2.consF(type, String.class, Cf2.listClass());
    }

    @SuppressWarnings("unchecked")
    public <A extends VcfProperty> A newProperty(String value, ListF<VcfParameter> parameters) {
        return (A) constructor.apply(value, parameters);
    }


} //~
