package ru.yandex.calendar.logic.layer;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerFields;
import ru.yandex.calendar.logic.event.EventDbManager;
import ru.yandex.calendar.logic.event.dao.EventLayerDao;
import ru.yandex.calendar.logic.notification.NotificationDbManager;
import ru.yandex.inside.passport.PassportUid;

/**
 * @see EventDbManager
 */
@Slf4j
public class LayerDbManager {
    @Autowired
    private LayerDao layerDao;
    @Autowired
    private LayerUserDao layerUserDao;
    @Autowired
    private EventLayerDao eventLayerDao;
    @Autowired
    private LayerInvitationDao layerInvitationDao;
    @Autowired
    private NotificationDbManager notificationDbManager;

    // TODO ssytnik: can simplify: move eventLayerDao.deleteEventLayersByLayerIds
    // to the top (check if it works), then reuse  deleteOnlyLayerWithNotification()
    public void deleteUserLayers(ListF<PassportUid> uids) {
        ListF<Layer> layers = layerDao.findLayersByUid(uids);
        ListF<Long> layerIds = layers.map(LayerFields.ID.getF());
        ListF<Long> layerUserIds = layerUserDao.findLayerUserIdsByLayerIds(layerIds);
        notificationDbManager.deleteNotificationsByLayerUserIds(layerUserIds);
        layerUserDao.deleteLayerUsersByIds(layerUserIds);
        layerInvitationDao.deleteLayerInvitationsByLayerIds(layerIds);
        eventLayerDao.deleteEventLayersByLayerIds(layerIds);
        layerDao.deleteLayerById(layerIds);
    }

    public void deleteUserNotPrimaryEventLayers(PassportUid uids) {
        ListF<Layer> layers = layerDao.findLayersByUid(Cf.list(uids));
        ListF<Long> layerIds = layers.map(LayerFields.ID.getF());
        eventLayerDao.deleteNotPrimaryEventLayersByLayerIds(layerIds);
    }

    /**
     * Does not delete layer contents.
     */
    public void deleteOnlyLayerWithNotification(long layerId) {
        ListF<Long> layerUserIds = layerUserDao.findLayerUserIdsByLayerIds(Cf.list(layerId));
        notificationDbManager.deleteNotificationsByLayerUserIds(layerUserIds);
        layerUserDao.deleteLayerUsersByIds(layerUserIds);
        layerInvitationDao.deleteLayerInvitationByLayerId(layerId);
        layerDao.deleteLayerById(Cf.list(layerId));
    }
}
