package ru.yandex.calendar.logic.layer;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.logic.beans.generated.LayerInvitation;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class LayerInvitationChangesInfo {
    private final ListF<LayerInvitation> newInvitations;
    private final ListF<LayerInvitation> updatedInvitations;
    private final ListF<LayerInvitation> removedInvitations;

    public LayerInvitationChangesInfo(
            ListF<LayerInvitation> newInvitations,
            ListF<LayerInvitation> updatedInvitations,
            ListF<LayerInvitation> removedInvitations)
    {
        this.newInvitations = newInvitations;
        this.updatedInvitations = updatedInvitations;
        this.removedInvitations = removedInvitations;
    }

    public ListF<LayerInvitation> getNewInvitations() {
        return newInvitations;
    }

    public ListF<LayerInvitation> getUpdatedInvitations() {
        return updatedInvitations;
    }

    public ListF<LayerInvitation> getRemovedInvitations() {
        return removedInvitations;
    }

    public ListF<PassportUid> getRemovedInvitationUids() {
        return getRemovedInvitations().filterMap(LayerInvitation.getUidF());
    }

    public ListF<PassportUid> getNewInvitationUids() {
        return getNewInvitations().filterMap(LayerInvitation.getUidF());
    }
} //~
