package ru.yandex.calendar.logic.layer;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.GenericBeanDao;
import ru.yandex.calendar.logic.beans.generated.LayerInvitation;
import ru.yandex.calendar.logic.beans.generated.LayerInvitationFields;
import ru.yandex.calendar.logic.beans.generated.LayerInvitationHelper;
import ru.yandex.calendar.util.db.CalendarJdbcDaoSupport;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlQueryUtils;
import ru.yandex.misc.email.Email;

/**
 * @author Stepan Koltsov
 */
public class LayerInvitationDao extends CalendarJdbcDaoSupport {

    @Autowired
    private GenericBeanDao genericBeanDao;


    @RunWithRandomTest
    public ListF<LayerInvitation> findLayerInvitationByLayerId(long layerId) {
        String q = "SELECT * FROM layer_invitation WHERE layer_id = ?";
        return getJdbcTemplate().queryForList(q, LayerInvitation.class, layerId);
    }

    @RunWithRandomTest
    public MapF<Long, Integer> findLayerInvitationsCountByLayerIds(ListF<Long> layerIds) {
        SqlCondition condition = LayerInvitationFields.LAYER_ID.column().inSet(layerIds);
        String q = "SELECT layer_id, COUNT(*) FROM layer_invitation " + condition.whereSql() + " GROUP BY layer_id";
        return getJdbcTemplate().queryForList2(q, Long.class, Integer.class, condition.args()).toMap();
    }

    @RunWithRandomTest
    public Option<LayerInvitation> findInvitationByPrivateToken(String privateToken) {
        String q = "SELECT * FROM layer_invitation WHERE private_token = ?";
        return getJdbcTemplate().queryForOption(q, LayerInvitation.class, privateToken);
    }

    @RunWithRandomTest
    public boolean findLayerInvitationExistsByLayerIdAndUid(long layerId, PassportUid uid) {
        String q = "SELECT COUNT(*) FROM layer_invitation WHERE layer_id = ? AND uid = ?";
        return getJdbcTemplate().queryForInt(q, layerId, uid) > 0;
    }

    @RunWithRandomTest
    public Option<LayerInvitation> findInvitationByLayerIdAndEmail(long layerId, Email email) {
        String q = "SELECT * FROM layer_invitation WHERE layer_id = ? AND email = ?";
        return getJdbcTemplate().queryForOption(q, LayerInvitation.class, layerId, email);
    }

    @RunWithRandomTest
    public Option<LayerInvitation> findInvitationByLayerIdAndUid(long layerId, PassportUid uid) {
        String q = "SELECT * FROM layer_invitation WHERE layer_id = ? AND uid = ?";
        return getJdbcTemplate().queryForOption(q, LayerInvitation.class, layerId, uid);
    }

    public void saveLayerInvitations(ListF<LayerInvitation> invitations) {
        genericBeanDao.insertBeans(invitations);
    }

    @RunWithRandomTest(possible=EmptyResultDataAccessException.class)
    public void deleteLayerInvitationByPrivateToken(String privateToken) {
        String q = "DELETE FROM layer_invitation WHERE private_token = ?";
        getJdbcTemplate().updateRow(q, privateToken);
    }

    @RunWithRandomTest
    public void deleteLayerInvitationByLayerIdAndUids(long layerId, ListF<PassportUid> uids) {
        String q = "DELETE FROM layer_invitation WHERE layer_id = ? AND uid " + SqlQueryUtils.inSet(uids);

        if (skipQuery(uids, q, layerId)) return;

        getJdbcTemplate().update(q, layerId);
    }

    @RunWithRandomTest(possible=EmptyResultDataAccessException.class)
    public void deleteLayerInvitationByLayerId(long layerId) {
        String q = "DELETE FROM layer_invitation WHERE layer_id = ?";
        getJdbcTemplate().update(q, layerId);
    }

    @RunWithRandomTest
    public void deleteLayerInvitationsByLayerIds(ListF<Long> layerIds) {
        String q = "DELETE FROM layer_invitation WHERE layer_id " + SqlQueryUtils.inSet(layerIds);

        if (skipQuery(layerIds, q)) return;

        getJdbcTemplate().update(q);
    }

    @RunWithRandomTest(possible=EmptyResultDataAccessException.class)
    public void deleteLayerInvitationById(LayerInvitationId id) {
        genericBeanDao.deleteBeanById(LayerInvitationHelper.INSTANCE, id.asTuple());
    }

    @RunWithRandomTest
    public void deleteLayerInvitationsByIds(ListF<LayerInvitationId> ids) {
        genericBeanDao.deleteBeans(LayerInvitationHelper.INSTANCE, LayerInvitationId.inSet(ids));
    }

    public void updateLayerInvitations(ListF<LayerInvitation> updates) {
        for (LayerInvitation update : updates) {
            genericBeanDao.updateBean(update);
        }
    }

    public void updateLayerInvitation(LayerInvitation temp) {
        genericBeanDao.updateBean(temp);
    }

} //~
