package ru.yandex.calendar.logic.layer;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.logic.beans.BeanHelper;
import ru.yandex.calendar.logic.beans.generated.LayerInvitation;
import ru.yandex.calendar.logic.beans.generated.LayerInvitationFields;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.misc.annotation.FillWithSomething;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.email.Email;

/**
 * @author dbrylev
 */
public class LayerInvitationId {
    private final long layerId;
    private final Email email;

    @FillWithSomething
    public LayerInvitationId(long layerId, Email email) {
        this.layerId = layerId;
        this.email = email;
    }

    public static LayerInvitationId of(LayerInvitation el) {
        return new LayerInvitationId(el.getLayerId(), el.getEmail());
    }

    public Tuple2<Long, Email> asTuple() {
        return Tuple2.tuple(layerId, email);
    }

    public static ListF<MapField<?>> fields() {
        return Cf.list(LayerInvitationFields.LAYER_ID, LayerInvitationFields.EMAIL);
    }

    public static SqlCondition inSet(CollectionF<LayerInvitationId> ids) {
        return BeanHelper.fieldsInSetCondition(fields(), ids.map(LayerInvitationId::asTuple));
    }

    public SqlCondition eq() {
        return inSet(Cf.set(this));
    }

    public long getLayerId() {
        return layerId;
    }

    public Email getEmail() {
        return email;
    }
}
