package ru.yandex.calendar.logic.layer;

import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerUser;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.color.ColorUtils;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.lang.Validate;

/**
 * @author Stepan Koltsov
 */
public class LayerRequestDataConverter {

    /**
     * From given layer data provider, fetches data and puts it to the new map
     * @param lDp layer data provider
     * @return created map with layer data
     */
    public static Layer convertLayerFromDataProvider(DataProvider lDp) {
        Layer layer = new Layer();
        String name = lDp.getText("name", true);
        name = StringUtils.take(StringUtils.notEmptyO(StringUtils.strip(name)).getOrNull(), LayerRoutines.MAX_NAME_LEN);
        layer.setName(LayerRoutines.DEFAULT_USER_LAYER_NAME.getAllNames().containsTs(name) ? null : name);
        return layer;
    }

    public static LayerUser convertLayerUserFromDataProvider(DataProvider layerUserDataProvider) {
        LayerUser layerUser = new LayerUser();
        String cssClass = layerUserDataProvider.getText("css-class", true);
        Validate.le(cssClass.length(), LayerRoutines.MAX_CSS_CLASS_LEN);
        layerUser.setCssClass(cssClass);
        layerUser.setHeadBgColor(ColorUtils.unformatColor(layerUserDataProvider.getText("head-bg-color", true)));
        layerUser.setHeadFgColor(ColorUtils.unformatColor(layerUserDataProvider.getText("head-fg-color", true)));
        layerUser.setBodyBgColor(ColorUtils.unformatColor(layerUserDataProvider.getText("body-bg-color", true)));
        layerUser.setIsNotifyChanges(Binary.parseBoolean(layerUserDataProvider.getText("is-notify-changes", false)));
        layerUser.setAffectsAvailability(Binary.parseBoolean(layerUserDataProvider.getText("affects-availability", false)));
        // permission (null is a valid layer_user.perm value which means 'use l.perm_all')
        return layerUser;
    }

} //~
