package ru.yandex.calendar.logic.layer;

import lombok.Getter;

import ru.yandex.calendar.logic.event.model.EventType;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;
import ru.yandex.misc.lang.CamelWords;

@Getter
public enum LayerType implements StringEnum {
    USER(EventType.USER),
    SERVICE(EventType.SERVICE),
    FEED(EventType.FEED),
    ABSENCE(EventType.ABSENCE),
    ;

    private final EventType myEventType;

    LayerType(EventType myEventType) {
        this.myEventType = myEventType;
    }

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }

    public static final StringEnumResolver<LayerType> R = StringEnumResolver.r(LayerType.class);

    public boolean isAbsence() {
        return myEventType.isAbsence();
    }
}
