package ru.yandex.calendar.logic.layer;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.calendar.util.color.Color;

/**
 * @author gutman
 */
public class LayerUserCssClassHack {

    private static final Tuple2List<String, Color> cssClassColors = Tuple2List.arrayList();

    /** @see /view/trunk/js/LayerControl.js */
    static {
        cssClassColors.add("custom",   Color.parseRgba("#6F9367FF"));
        cssClassColors.add("calendar", Color.parseRgba("#6482A1FF"));
        cssClassColors.add("inbox",    Color.parseRgba("#D0C1DFFF"));
        cssClassColors.add("out",      Color.parseRgba("#49C0A8FF"));
        cssClassColors.add("custom5",  Color.parseRgba("#F17E20FF"));
        cssClassColors.add("custom6",  Color.parseRgba("#B38A4DFF"));
        cssClassColors.add("custom7",  Color.parseRgba("#8F499EFF"));
        cssClassColors.add("custom8",  Color.parseRgba("#0D866AFF"));
        cssClassColors.add("custom9",  Color.parseRgba("#774A5EFF"));
        cssClassColors.add("custom10", Color.parseRgba("#D54F8EFF"));
        cssClassColors.add("custom11", Color.parseRgba("#9DAE00FF"));
        cssClassColors.add("custom12", Color.parseRgba("#2596C0FF"));
        cssClassColors.add("custom13", Color.parseRgba("#A23C50FF"));
        cssClassColors.add("custom14", Color.parseRgba("#3C41ACFF"));
        cssClassColors.add("custom15", Color.parseRgba("#989B04FF"));
    }

    public static String getBestMatchingCssClassByColor(Color color) {
        return getBestMatchingCssClassByColor(color, cssClassColors);
    }

    static String getBestMatchingCssClassByColor(Color color, Tuple2List<String, Color> cssClassColors) {
        return cssClassColors.min(Tuple2.<String, Color>get2F().andThen(Color.distanceF().bind1(color)).andThenNaturalComparator())._1;
    }

}

