package ru.yandex.calendar.logic.layer;

import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerUser;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;
import ru.yandex.calendar.util.color.Color;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class LayerUserWithRelations {
    private final LayerUser layerUser;
    private final Layer layer;
    private final String evaluatedLayerName;
    private final Color evaluatedColor;

    public LayerUserWithRelations(LayerUser layerUser, Layer layer, String evaluatedLayerName, Color evaluatedColor) {
        this.layerUser = layerUser;
        this.layer = layer;
        this.evaluatedLayerName = evaluatedLayerName;
        this.evaluatedColor = evaluatedColor;
    }

    public Layer getLayer() {
        return layer;
    }

    public LayerUser getLayerUser() {
        return layerUser;
    }

    public long getLayerId() {
        return layer.getId();
    }

    public boolean layerIdIs(long layerId) {
        return getLayerId() == layerId;
    }

    public long getLayerUserId() {
        return layerUser.getId();
    }

    public boolean affectsAvailability() {
        return layerUser.getAffectsAvailability();
    }

    public boolean isAnonymousSharing() {
        return layerUser.getPerm() == LayerActionClass.ACCESS;
    }

    public PassportUid getLayerCreatorUid() {
        return layer.getCreatorUid();
    }

    public PassportUid getLayerUserUid() {
        return layerUser.getUid();
    }

    public boolean layerCreatorIs(PassportUid uid) {
        return getLayerCreatorUid().sameAs(uid);
    }

    public boolean layerUserIsLayerCreator() {
        return layer.getCreatorUid().sameAs(layerUser.getUid());
    }

    public String getEvaluatedLayerName() {
        return evaluatedLayerName;
    }

    public Color getEvaluatedColor() {
        return evaluatedColor;
    }
} //~
