package ru.yandex.calendar.logic.layer;

import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import one.util.streamex.EntryStream;

import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;
import ru.yandex.calendar.micro.perm.LayerAction;
import ru.yandex.inside.passport.PassportUid;

import static java.util.Collections.emptyMap;
import static java.util.Collections.emptySet;

@Slf4j
public class UserLayersSharing {
    private final Map<Long, Set<LayerAction>> legacyPermByLayerId;

    public UserLayersSharing(Map<Long, Set<LayerAction>> legacyPermByLayerId) {
        this.legacyPermByLayerId = legacyPermByLayerId;
    }

    public List<Long> getOwnedLayerIds(boolean correctCheck) {
        if (correctCheck) {
            return EntryStream.of(legacyPermByLayerId)
                    .filterValues(actions -> actions != null && actions.contains(LayerAction.GRANT))
                    .keys()
                    .toImmutableList();
        } else {
            return EntryStream.of(legacyPermByLayerId)
                    .filterValues(actions -> LayerActionClass.ADMIN.getActions().containsAll(actions))
                    .keys()
                    .toImmutableList();
        }
    }

    public List<Long> getLayerIdsSharedFor(LayerAction action) {
        return EntryStream.of(legacyPermByLayerId)
                .filterValues(perm -> perm.contains(action))
                .keys()
                .toImmutableList();
    }

    public Set<LayerAction> get(long layerId) {
        return legacyPermByLayerId.getOrDefault(layerId, emptySet());
    }

    public boolean containsAction(Layer layer, LayerAction action) {
        return containsAction(layer.getId(), action);
    }

    public boolean containsAction(long layerId, LayerAction action) {
        return legacyPermByLayerId.getOrDefault(layerId, emptySet()).contains(action);
    }

    public static UserLayersSharing empty() {
        return new UserLayersSharing(emptyMap());
    }

    @Value
    @AllArgsConstructor
    public static class LayerPermissionSettings {
        long layerId;
        Set<LayerAction> actions;
        PassportUid creatorUid;
    }
}
