package ru.yandex.calendar.logic.layer.common;

import java.util.List;
import java.util.stream.Collectors;

import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.logic.beans.generated.LayerUser;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.sharing.perm.LayerActionClass;
import ru.yandex.calendar.logic.staff.dao.UsersDao;
import ru.yandex.calendar.logic.user.UserDao;
import ru.yandex.calendar.micro.yt.entity.UserIdWIthDepartmentSlugs;
import ru.yandex.inside.passport.PassportUid;

public class CommonLayersChecker {
    @Autowired
    private UserDao users;
    @Autowired
    private UsersDao staffUsers;
    @Autowired
    private LayerRoutines layerRoutines;

    public void execute(CheckerConfig config) {
        Duration duration = Duration.standardDays(config.getPeriod());
        Instant time = Instant.now().minus(duration);

        ListF<PassportUid> newStaffUsers = users.findUsersCreatedAfterDate(time);
        List<UserIdWIthDepartmentSlugs> usersWithDepartments = staffUsers.findUserDepartmentsByUids(newStaffUsers);

        config.getLayers().forEach((departmentSlug, layerIds) -> {
            List<PassportUid> currentDepartmentUsers = usersWithDepartments.stream()
                    .filter(user -> user.getDepartmentSlugs().contains(departmentSlug))
                    .map(UserIdWIthDepartmentSlugs::getUid)
                    .map(PassportUid::new)
                    .collect(Collectors.toList());

            attachDepartmentLayer(currentDepartmentUsers, layerIds);
        });
    }

    private void attachDepartmentLayer(List<PassportUid> users, List<Long> layerIds) {
        layerIds.forEach(layerId -> {
            users.forEach(uid -> {
                attachIfNot(layerId, uid);
            });
        });
    }

    private void attachIfNot(Long layerId, PassportUid uid) {
        LayerUser overrides = new LayerUser();
        overrides.setPerm(LayerActionClass.VIEW);

        Option<LayerUser> data = layerRoutines.getLayerUser(layerId, uid);

        if (data.isEmpty()) {
            layerRoutines.createLayerUserForUserAndLayer(uid, layerId, overrides, Cf.list());
        }
    }
}
