package ru.yandex.calendar.logic.log;

import java.util.Optional;

import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.calendar.logic.event.EventInfo;
import ru.yandex.calendar.logic.event.EventWithRelations;

public class EventIdLogDataJson {
    public final long eventId;
    public final long mainEventId;
    public final String externalId;
    public Optional<Instant> recurrenceId;

    public EventIdLogDataJson(EventInfo event) {
        this(event.getEventWithRelations());
    }

    public EventIdLogDataJson(EventWithRelations event) {
        this(event.getId(), event.getMainEventId(), event.getExternalId(), event.getRecurrenceId().toOptional());
    }

    public EventIdLogDataJson(long eventId, MainEvent mainEvent, Optional<Instant> recurrenceId) {
        this(eventId, mainEvent.getId(), mainEvent.getExternalId(), recurrenceId);
    }

    public EventIdLogDataJson(MainEvent mainEvent, Event event) {
        this(mainEvent.getExternalId(), event);
    }

    public EventIdLogDataJson(String externalId, Event event) {
        this(event.getId(), event.getMainEventId(), externalId, event.getRecurrenceId().toOptional());
    }

    public EventIdLogDataJson(long eventId, long mainEventId, String externalId, Optional<Instant> recurrenceId) {
        this.eventId = eventId;
        this.mainEventId = mainEventId;
        this.externalId = externalId;
        this.recurrenceId = recurrenceId;
    }

    public EventIdLogDataJson withRecurrenceId(Instant recurrenceId) {
        return new EventIdLogDataJson(eventId, mainEventId, externalId, Optional.of(recurrenceId));
    }
}
