package ru.yandex.calendar.logic.log;

import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.log4j.helpers.PatternParser;

import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.calendar.logic.log.converters.CalendarPatternParser;
import ru.yandex.misc.log.log4j.YandexPatternLayout;
import ru.yandex.misc.net.HostnameUtils;

public class JsonLogPatternLayout extends YandexPatternLayout {
    private static final String PATTERN_TEMPLATE = "{"
            + "\"datetime\": \"%%d{yyyy-MM-dd HH:mm:ss.SSS}\", "
            + "\"unixtime\": %%D, "
            + "\"level\": \"%%p\", "
            + "\"host\": \"%s\", "
            + "\"app\": \"%s\", "
            + "\"rid\": \"%%R\", "
            + "\"thread\": \"%%t\", "
            + "\"class\": \"%%c\", "
            + "\"message\": \"%%M\""
            + "}%%n";

    /** @see org.apache.commons.lang3.StringEscapeUtils#ESCAPE_JSON */
    static final CharSequenceTranslator ESCAPE_JSON = new AggregateTranslator(
            new LookupTranslator(new String[][] {
                    {"\"", "\\\""},
                    {"\\", "\\\\"}}
            ),
            new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()),
            JavaUnicodeEscaper.below(32));

    public JsonLogPatternLayout(CalendarAppName appName) {
        super(String.format(PATTERN_TEMPLATE, HostnameUtils.localHostnameShort(), appName.xmlName()));
    }

    @Override
    public boolean ignoresThrowable() {
        return false;
    }

    @Override
    protected PatternParser createPatternParser(String s) {
        return new CalendarPatternParser(s, ESCAPE_JSON::translate);
    }
}
