package ru.yandex.calendar.logic.log.change;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonUnwrapped;

import ru.yandex.calendar.logic.event.ActionInfo;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.ActorId;
import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;

public class EventChangeLogEventJson extends LogEvent {
    private final String actor;
    private final EventChangeType changeType;
    @JsonUnwrapped
    private final EventIdLogDataJson eventId;
    @JsonUnwrapped
    private final EventChangesJson changes;

    public EventChangeLogEventJson(ActorId actor, EventChangeType changeType, EventIdLogDataJson eventId, EventChangesJson changes) {
        this.actor = actor.toSerializedString();
        this.changeType = changeType;
        this.eventId = eventId;
        this.changes = changes;
    }

    @Override
    public boolean isAccept(ActionInfo actionInfo) {
        if (actionInfo.getActionSource() == ActionSource.WEB_ICS && eventId.externalId.endsWith("@kinopoisk.ru")) {
            return false;
        }
        return !changes.isEmpty();
    }

    @Override
    public boolean isOmitDatabasing(ActionInfo actionInfo) {
        return changeType == EventChangeType.DELETE_SPAM;
    }

    @JsonGetter
    public LogEventType type() {
        return LogEventType.EVENT_CHANGE;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.of(eventId);
    }
}
