package ru.yandex.calendar.logic.log.change;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonGetter;

import ru.yandex.calendar.logic.log.EventIdLogDataJson;
import ru.yandex.calendar.logic.log.LogEvent;
import ru.yandex.calendar.logic.log.LogEventType;

public class ExternalIdChangeLogEventJson extends LogEvent {
    private final String externalIdOld;
    private final String externalIdNew;
    private final String changeType = EventChangeType.UPDATE.toString().toLowerCase();

    public ExternalIdChangeLogEventJson(String externalIdOld, String externalIdNew) {
        this.externalIdOld = externalIdOld;
        this.externalIdNew = externalIdNew;
    }

    @JsonGetter
    @Override
    public LogEventType type() {
        return LogEventType.EVENT_CHANGE;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public Optional<EventIdLogDataJson> getEventId() {
        return Optional.empty();
    }
}
