package ru.yandex.calendar.logic.log.change.changes;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.event.EventWithRelations;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChange;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChangeSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

@BenderBindAllFields
public class EventFieldsChangesJson {
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<String> name;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<String> description;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<String> location;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<String> url;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Instant> start;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Instant> end;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Integer> sequence;

    public EventFieldsChangesJson(
            FieldChange<String> name, FieldChange<String> description, FieldChange<String> location,
            FieldChange<String> url, FieldChange<Instant> start, FieldChange<Instant> end, FieldChange<Integer> sequence) {
        this.name = name;
        this.description = description;
        this.location = location;
        this.url = url;
        this.start = start;
        this.end = end;
        this.sequence = sequence;
    }

    public static EventFieldsChangesJson empty() {
        return new EventFieldsChangesJson(
                FieldChange.empty(), FieldChange.empty(), FieldChange.empty(),
                FieldChange.empty(), FieldChange.empty(), FieldChange.empty(), FieldChange.empty());
    }

    public static EventFieldsChangesJson of(Optional<Event> old, Event cur) {
        return new EventFieldsChangesJson(
                FieldChange.of(EventFields.NAME, old, cur),
                FieldChange.of(EventFields.DESCRIPTION, old, cur),
                FieldChange.of(EventFields.LOCATION, old, cur),
                FieldChange.of(EventFields.URL, old, cur),
                FieldChange.of(EventFields.START_TS, old, cur),
                FieldChange.of(EventFields.END_TS, old, cur),
                FieldChange.of(EventFields.SEQUENCE, old, cur));
    }

    public static EventFieldsChangesJson find(Optional<EventWithRelations> old, Optional<EventWithRelations> cur) {
        return of(old.map(EventWithRelations::getEvent), cur.orElseGet(old::get).getEvent());
    }

    public static EventFieldsChangesJson incrementedSequence(Event event) {
        return new EventFieldsChangesJson(
                FieldChange.empty(), FieldChange.empty(), FieldChange.empty(), FieldChange.empty(),
                FieldChange.empty(), FieldChange.empty(), new FieldChange<>(event.getSequence(), event.getSequence() + 1));
    }

    public boolean isEmpty() {
        return name.isEmpty() && description.isEmpty() && location.isEmpty()
                && url.isEmpty() && start.isEmpty() && end.isEmpty() && sequence.isEmpty();
    }
}
