package ru.yandex.calendar.logic.log.change.changes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.val;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ExdatesChangesJson {
    public final List<Instant> removed;
    public final List<Instant> added;

    public ExdatesChangesJson(List<Instant> removed, List<Instant> added) {
        this.removed = removed;
        this.added = added;
    }

    public static ExdatesChangesJson empty() {
        return new ExdatesChangesJson(new ArrayList<>(), new ArrayList<>());
    }

    private static List<Instant> filterExdateStarts(List<Instant> old, List<Instant> cur) {
        return old.stream().filter(v -> !cur.contains(v)).collect(Collectors.toList());
    }

    public static ExdatesChangesJson find(Optional<RepetitionInstanceInfo> old, Optional<RepetitionInstanceInfo> cur) {
        val oldStarts = old.map(v -> (List<Instant>)v.getExdateStarts()).orElse(new ArrayList<>());
        val curStarts = cur.map(v -> (List<Instant>)v.getExdateStarts()).orElse(new ArrayList<>());
        return new ExdatesChangesJson(filterExdateStarts(oldStarts, curStarts), filterExdateStarts(curStarts, oldStarts));
    }

    public Optional<ExdatesChangesJson> toOptional() {
        return isEmpty() ? Optional.empty() : Optional.of(this);
    }

    public boolean isEmpty() {
        return removed.isEmpty() && added.isEmpty();
    }
}
