package ru.yandex.calendar.logic.log.change.changes;

import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventUser;

/**
 * @author dbrylev
 */
public enum Participation {
    ORGANIZER,
    ATTENDEE,
    SUBSCRIBER,
    NONE,
    ;

    public static Participation of(EventUser eu) {
        if (eu.getIsOrganizer()) {
            return ORGANIZER;
        }
        if (eu.getIsAttendee()) {
            return ATTENDEE;
        }
        if (eu.getIsSubscriber()) {
            return SUBSCRIBER;
        }
        return NONE;
    }

    public static Participation of(EventInvitation inv) {
        return inv.getIsOrganizer() ? ORGANIZER : ATTENDEE;
    }
}
