package ru.yandex.calendar.logic.log.change.changes;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.val;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;

@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class RepetitionChangesJson {
    private final Optional<RepetitionFieldsChangesJson> rule;
    private final Optional<ExdatesChangesJson> exdates;

    public RepetitionChangesJson(RepetitionFieldsChangesJson rule, ExdatesChangesJson exdates) {
        this.rule = rule.toOptional();
        this.exdates = exdates.toOptional();
    }

    public static RepetitionChangesJson empty() {
        return new RepetitionChangesJson(RepetitionFieldsChangesJson.empty(), ExdatesChangesJson.empty());
    }

    public static RepetitionChangesJson exdateAdded(Instant exdate) {
        return new RepetitionChangesJson(RepetitionFieldsChangesJson.empty(), new ExdatesChangesJson(Cf.list(), Cf.list(exdate)));
    }

    public static RepetitionChangesJson find(Optional<RepetitionInstanceInfo> old, Optional<RepetitionInstanceInfo> cur) {
        val rule = RepetitionFieldsChangesJson.of(
                old.map(r -> r.getRepetition().getOrElse(RepetitionRoutines::createNoneRepetition)),
                cur.orElseGet(old::get).getRepetition().getOrElse(RepetitionRoutines::createNoneRepetition));
        return new RepetitionChangesJson(rule, ExdatesChangesJson.find(old, cur));
    }

    public Optional<RepetitionChangesJson> toOptional() {
        return isEmpty() ? Optional.empty() : Optional.of(this);
    }

    public boolean isEmpty() {
        return !rule.isPresent() && !exdates.isPresent();
    }
}
