package ru.yandex.calendar.logic.log.change.changes;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.joda.time.Instant;

import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.beans.generated.RepetitionFields;
import ru.yandex.calendar.logic.event.repetition.RegularRepetitionRule;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChange;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChangeSerializer;

public class RepetitionFieldsChangesJson {
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<RegularRepetitionRule> type;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Integer> each;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Instant> due;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<String> weeklyDays;
    @JsonSerialize(using = FieldChangeSerializer.class)
    @JsonUnwrapped
    public final FieldChange<Boolean> monthlyLastweek;

    public RepetitionFieldsChangesJson(
            FieldChange<RegularRepetitionRule> type, FieldChange<Integer> each,
            FieldChange<Instant> due, FieldChange<String> weeklyDays, FieldChange<Boolean> monthlyLastweek) {
        this.type = type;
        this.each = each;
        this.due = due;
        this.weeklyDays = weeklyDays;
        this.monthlyLastweek = monthlyLastweek;
    }

    public static RepetitionFieldsChangesJson empty() {
        return new RepetitionFieldsChangesJson(
                FieldChange.empty(), FieldChange.empty(), FieldChange.empty(), FieldChange.empty(), FieldChange.empty());
    }

    public static RepetitionFieldsChangesJson of(Optional<Repetition> old, Repetition cur) {
        return new RepetitionFieldsChangesJson(
                FieldChange.of(RepetitionFields.TYPE, old, cur),
                FieldChange.of(RepetitionFields.R_EACH, old, cur),
                FieldChange.of(RepetitionFields.DUE_TS, old, cur),
                FieldChange.of(RepetitionFields.R_WEEKLY_DAYS, old, cur),
                FieldChange.of(RepetitionFields.R_MONTHLY_LASTWEEK, old, cur));
    }

    Optional<RepetitionFieldsChangesJson> toOptional() {
        return isEmpty() ? Optional.empty() : Optional.of(this);
    }

    public boolean isEmpty() {
        return type.isEmpty() && each.isEmpty() && due.isEmpty() && weeklyDays.isEmpty() && monthlyLastweek.isEmpty()
                || !type.getOld().isPresent() && type.getCur().isSome(RegularRepetitionRule.NONE);
    }
}
