package ru.yandex.calendar.logic.log.change.changes;

import java.util.Comparator;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventInvitationFields;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.EventUserFields;
import ru.yandex.calendar.logic.event.EventUserWithRelations;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChange;
import ru.yandex.calendar.logic.log.change.changes.field.FieldChangeSerializer;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

public class UserChangesJson {
    public static final Comparator<UserChangesJson> comparator =
            Comparator.<UserChangesJson, Boolean>comparing(u -> !u.uid.isPresent())
                    .thenComparing(u -> u.email);

    private final Optional<Long> uid;
    private final String email;
    @JsonSerialize(using= FieldChangeSerializer.class)
    @JsonUnwrapped
    private final FieldChange<Decision> decision;
    @JsonSerialize(using= FieldChangeSerializer.class)
    @JsonUnwrapped
    private final FieldChange<Availability> availability;
    @JsonSerialize(using= FieldChangeSerializer.class)
    @JsonUnwrapped
    private final FieldChange<Participation> participation;

    public UserChangesJson(
            Optional<PassportUid> uid, Email email,
            FieldChange<Decision> decision,
            FieldChange<Availability> availability,
            FieldChange<Participation> participation)
    {
        this.uid = uid.map(v -> v.toUidOrZero().getUid());
        this.email = email.getEmail();
        this.decision = decision;
        this.availability = availability;
        this.participation = participation;
    }

    public static UserChangesJson of(Optional<EventUserWithRelations> old, EventUserWithRelations cur) {
        return of(cur.getSettings().getEmail(), old.map(EventUserWithRelations::getEventUser), cur.getEventUser());
    }

    public static UserChangesJson of(Email email, Optional<EventUser> old, EventUser cur) {
        return new UserChangesJson(
                Optional.of(cur.getUid()), email,
                FieldChange.of(EventUserFields.DECISION, old, cur),
                FieldChange.of(EventUserFields.AVAILABILITY, old, cur),
                FieldChange.of(old.map(Participation::of), Participation.of(cur)));
    }

    public static UserChangesJson of(Optional<EventInvitation> old, EventInvitation cur) {
        return new UserChangesJson(
                Optional.empty(), cur.getEmail(),
                FieldChange.of(EventInvitationFields.DECISION, old, cur),
                FieldChange.empty(),
                FieldChange.of(old.map(Participation::of), Participation.of(cur)));
    }

    public boolean isEmpty() {
        return decision.isEmpty() && availability.isEmpty() && participation.isEmpty();
    }
}
