package ru.yandex.calendar.logic.log.change.changes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import lombok.val;

import ru.yandex.bolts.function.Function2;
import ru.yandex.calendar.logic.beans.generated.EventInvitation;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.EventAttachedLayerId;
import ru.yandex.calendar.logic.event.EventAttachedUser;
import ru.yandex.misc.email.Email;

public class UserRelatedChangesJson {
    public final UsersChangesJson userChanges;
    public final Optional<EventAttachedLayerId> layerChanges;

    public UserRelatedChangesJson(UsersChangesJson usersChanges, EventAttachedLayerId layersChanges) {
        this.userChanges = usersChanges;
        this.layerChanges = Optional.of(layersChanges);
    }

    public UserRelatedChangesJson(UsersChangesJson usersChanges, Optional<EventAttachedLayerId> layersChanges) {
        this.userChanges = usersChanges;
        this.layerChanges = layersChanges;
    }

    public static UserRelatedChangesJson find(Email email, EventAttachedUser user) {
        return find(email, user.eventUser.old.toOptional(), user.eventUser.cur.toOptional(), user.layerId.toOptional());
    }

    public static UserRelatedChangesJson find(
            Email email, Optional<EventUser> oldEu, Optional<EventUser> curEu, Optional<EventAttachedLayerId> layerId)
    {
        return new UserRelatedChangesJson(find(oldEu, curEu, (o, c) -> UserChangesJson.of(email, o, c)), layerId);
    }

    public static UserRelatedChangesJson find(Optional<EventInvitation> oldInv, Optional<EventInvitation> curInv) {
        return new UserRelatedChangesJson(find(oldInv, curInv, UserChangesJson::of), Optional.empty());
    }

    private static <T> UsersChangesJson find(Optional<T> old, Optional<T> cur, Function2<Optional<T>, T, UserChangesJson> cons) {
        List<UserChangesJson> removed = new ArrayList<>();
        List<UserChangesJson> updated = new ArrayList<>();
        List<UserChangesJson> added = new ArrayList<>();

        if (cur.isPresent() && old.isPresent()) {
            val update = cons.apply(old, cur.get());
            if (!update.isEmpty()) {
                updated.add(update);
            }
        } else if (cur.isPresent()) {
            val add = cons.apply(Optional.empty(), cur.get());
            if (!add.isEmpty()) {
                added.add(add);
            }
        } else if (old.isPresent()) {
            val remove = cons.apply(Optional.empty(), old.get());
            if (!remove.isEmpty()) {
                removed.add(remove);
            }
        }
        return new UsersChangesJson(removed, updated, added);
    }
}
