package ru.yandex.calendar.logic.log.change.changes.field;

import java.util.Optional;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.mapObject.MapField;
import ru.yandex.commune.mapObject.MapObject;
import ru.yandex.misc.lang.DefaultObject;

public class FieldChange<T> extends DefaultObject {
    private final Option<T> old;
    private final Option<T> cur;

    public FieldChange(T old, T cur) {
        this(Option.of(old), Option.of(cur));
    }

    public FieldChange(Option<T> old, Option<T> cur) {
        this.old = old;
        this.cur = cur;
    }

    public static <T> FieldChange<T> empty() {
        return new FieldChange<>(Option.empty(), Option.empty());
    }

    public static <T> FieldChange<T> of(Option<T> old, T cur) {
        return old.isSome(cur) ? FieldChange.empty() : new FieldChange<>(old, Option.of(cur));
    }

    public static <T> FieldChange<T> of(Optional<T> old, T cur) {
        return of(old.map(Option::of).orElseGet(Option::empty), cur);
    }

    public static <T> FieldChange<T> of(MapField<T> field, MapObject after) {
        return new FieldChange<>(Option.empty(), after.getFieldValueNullAsNone(field));
    }

    public static <T> FieldChange<T> of(MapField<T> field, Option<? extends MapObject> old, MapObject cur) {
        Option<T> b = old.map(o -> o.getFieldValueO(field).getOrNull());
        T a = cur.getFieldValueO(field).getOrNull();

        return of(b, a);
    }

    public static <T> FieldChange<T> of(MapField<T> field, Optional<? extends MapObject> old, MapObject cur) {
        return of(field, old.map(Option::of).orElseGet(Option::empty), cur);
    }

    public boolean isEmpty() {
        return !old.isPresent() && !cur.isPresent();
    }

    public Option<T> getOld() {
        return old;
    }

    public Option<T> getCur() {
        return cur;
    }
}
