package ru.yandex.calendar.logic.log.change.changes.field;

import java.io.IOException;
import java.util.Optional;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;

public class FieldChangeSerializer extends JsonSerializer<FieldChange<?>> implements ContextualSerializer {
    private final String name;

    public FieldChangeSerializer() {
        this.name = "";
    }

    public FieldChangeSerializer(String name) {
        this.name = name;
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return true;
    }

    @Override
    public void serialize(FieldChange<?> field, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        if (field.getOld().isPresent() && field.getCur().isPresent()) {
            jsonGenerator.writeObjectField(name + "_old", Optional.ofNullable(field.getOld().getOrNull()));
            jsonGenerator.writeObjectField(name, Optional.ofNullable(field.getCur().getOrNull()));
        } else if (field.getCur().isPresent()) {
            jsonGenerator.writeObjectField(name, Optional.ofNullable(field.getCur().getOrNull()));
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
        return new FieldChangeSerializer(property.getName());
    }
}
