package ru.yandex.calendar.logic.log.converters;

import java.text.SimpleDateFormat;

import lombok.val;
import org.apache.log4j.helpers.PatternConverter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.log.log4j.YandexPatternParser;
import ru.yandex.misc.time.MoscowTime;

public class CalendarPatternParser extends YandexPatternParser {
    private final Function<String, String> escaper;

    public CalendarPatternParser(String pattern, Function<String, String> escaper) {
        super(pattern);
        this.escaper = escaper;
    }

    @Override
    protected void finalizeConverter(char c) {
        if (c == 'D') {
            addConverter(new UnixTimeConverter(formattingInfo));
        } else if (c == 'd') {
            val format = new SimpleDateFormat(
                    Option.ofNullable(extractOption()).getOrElse("yyyy-MM-dd HH:mm:ss.SSS"));
            format.setTimeZone(MoscowTime.TZ.toTimeZone());
            addConverter(new DateTimeConverter(formattingInfo, format));
        } else if (c == 'R') {
            addConverter(new RidConverter(formattingInfo));
        } else if (c == 'M') {
            if ("E".equals(extractOption())) {
                super.addConverter(new MessageConverter(formattingInfo));
            } else {
                addConverter(new MessageConverter(formattingInfo));
            }
        } else {
            super.finalizeConverter(c);
        }
    }

    @Override
    protected void addConverter(PatternConverter pc) {
        super.addConverter(new EscapingConverter(pc, escaper));
    }
}
