package ru.yandex.calendar.logic.log.converters;

import java.text.DateFormat;
import java.util.Date;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author dbrylev
 */
public class DateTimeConverter extends PatternConverter {
    private final DateFormat format;
    private final Date date;

    public DateTimeConverter(FormattingInfo fi, DateFormat format) {
        super(fi);
        this.format = format;
        this.date = new Date();
    }

    @Override
    protected String convert(LoggingEvent event) {
        date.setTime(event.getTimeStamp());

        return format.format(date);
    }
}
