package ru.yandex.calendar.logic.log.converters;

import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function2;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author dbrylev
 */
public class EscapingConverter extends PatternConverter {

    @SuppressWarnings("unchecked")
    private static final Function2<PatternConverter, LoggingEvent, String> convert =
            ClassX.wrap(PatternConverter.class).getDeclaredMethod("convert", LoggingEvent.class).toSam(Function2.class);

    private final Function<LoggingEvent, String> converter;

    public EscapingConverter(PatternConverter converter, Function<String, String> escaper) {
        this.converter = convert.bind1(converter).andThen(escaper);
    }

    @Override
    protected String convert(LoggingEvent event) {
        return converter.apply(event);
    }
}
