package ru.yandex.calendar.logic.log.converters;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

/**
 * @author dbrylev
 */
public class MessageConverter extends PatternConverter {

    public MessageConverter(FormattingInfo fi) {
        super(fi);
    }

    @Override
    protected String convert(LoggingEvent event) {
        String message = event.getRenderedMessage();

        String[] stringRepresentation = event.getThrowableStrRep();
        if (stringRepresentation != null && stringRepresentation.length > 0) {
            StringBuilder result = new StringBuilder(message);

            for (String part : stringRepresentation) {
                result.append("\n");
                result.append(part);
            }
            return result.toString();
        }
        return message;
    }
}
