package ru.yandex.calendar.logic.log.converters;

import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.spi.LoggingEvent;

import ru.yandex.misc.regex.Matcher2;
import ru.yandex.misc.regex.Pattern2;

/**
 * @author dbrylev
 */
public class RidConverter extends PatternConverter {
    private static final Pattern2 pattern = Pattern2.compile("\\brid=([^,$]+)");

    public RidConverter(FormattingInfo fi) {
        super(fi);
    }

    @Override
    protected String convert(LoggingEvent event) {
        String ndc = (String) event.getMDC("ndc");

        if (ndc != null) {
            Matcher2 m = pattern.matcher2(ndc);

            if (m.find() && m.group(1).isPresent()) {
                return m.group(1).get();
            }
        }
        return "-";
    }
}
