package ru.yandex.calendar.logic.log.requests;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.springframework.web.util.ContentCachingRequestWrapper;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.boot.CalendarAppName;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.web.servlet.ServletUtils;

public class RequestContentCachingFilter implements Filter {

    private final DynamicProperty<ListF<String>> includeUriPatterns;
    private final DynamicProperty<ListF<String>> excludeUriPatterns;

    public RequestContentCachingFilter(CalendarAppName app) {
        String prefix = "requestsLog." + app.appName() + ".uriPatterns.";

        includeUriPatterns = new DynamicProperty<>(prefix + "include", Cf.list());
        excludeUriPatterns = new DynamicProperty<>(prefix + "exclude", Cf.list("/ping/*"));
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws ServletException, IOException {

        HttpServletRequest httpRequest = (HttpServletRequest) request;

        String requestUri = httpRequest.getRequestURI();
        Function1B<String> matchesF = x -> ServletUtils.uriMatches(x, requestUri);

        if (includeUriPatterns.get().exists(matchesF) && !excludeUriPatterns.get().exists(matchesF)) {
            chain.doFilter(new ContentCachingRequestWrapper(httpRequest), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}
