package ru.yandex.calendar.logic.log.requests;

import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.api.mail.DownloadIcsBinder;
import ru.yandex.calendar.frontend.api.mail.DownloadedIcs;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.intercept.InvocationInterceptorOrders;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.utils.ParameterRef;
import ru.yandex.commune.a3.utils.ParameterRetriever;
import ru.yandex.commune.a3.utils.ParameterRetrieverFactory;
import ru.yandex.inside.passport.PassportUid;

public class RequestLoggingInterceptor implements ActionInvocationInterceptor {

    private final ParameterRetriever<PassportUid> uidRetriever =
            ParameterRetrieverFactory.cons(PassportUid.class, ParameterRef.request("uid"));

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        ContentCachingRequestWrapper request = WebUtils.getNativeRequest(
                invocation.getWebRequest().getHttpServletRequest(),
                ContentCachingRequestWrapper.class);

        if (request == null) {
            return invocation.invoke();
        }
        Option<PassportUid> uid = uidRetriever.retrieve(invocation.getWebRequest(), invocation.getContext());

        if (!uid.isPresent()) {
            return invocation.invoke();
        }
        Option<IcsCalendar> ics = invocation.getParameters()
                .find(p -> p.getDescriptor().getParameterType().getActualType().sameAs(DownloadedIcs.class))
                .map(DownloadIcsBinder::requireValue)
                .map(DownloadedIcs::getCalendar);

        RequestsLogger.log(request, uid.get(), ics);

        return invocation.invoke();
    }

    @Override
    public int getOrder() {
        return InvocationInterceptorOrders.RESPONSE_INTERCEPTOR_ORDER;
    }
}
